# StepUp Advanced

StepUp Advanced takes the convenience of the original [StepUp][SU] mod for [*Vintage Story*][VS] to the next level. With fully customizable settings, intuitive toggle options, and server compatibility, this mod provides a seamless experience for navigating terrain. Whether you're exploring rugged mountains or building intricate structures, StepUp Advanced enhances mobility and efficiency.

[SU]: https://mods.vintagestory.at/stepup
[VS]: https://www.vintagestory.at/

## Features
- **Server-Enforced Limits:** Server owners can define the minimum and maximum allowed step height and speed. Clients cannot exceed these values when enforcement is active.
- **Configurable Step Height:** Adjust your step height between 0.2 and 2 blocks, making it perfect for varied terrain and playstyles.
- **Configurable Step Speed:** Adjust your step up speed between 0.5 and 2 speed, allowing a quicker traversal of terrain.
- **Configurable Blacklist:** Add or remove block codes to the block blacklist, preventing the step-up function for blocks listed.
- **Dynamic Toggle:** Enable or disable StepUp functionality in real time with a hotkey. (Default: Insert)
- **Real-Time Adjustments:** Increase or decrease step height and step speed on the fly using customizable hotkeys ([Step Height] Default: PageUp and PageDown & [Step Speed] Default: ArrowUp and ArrowDown).
- **Reloadable Configuration:** Easily reload your settings mid-game with a hotkey, without restarting. (Default: Home)
- **Immersive Feedback:** Chat notifications and logs keep you updated on changes to your configuration and usage.

## Controls - Keybinds
- **Insert** - Toggle On/Off
- **Home** - Reload Config
- **PageUp** - Increase Step Height
- **PageDown** - Decrease Step Height
- **UpArrow** - Increase Step Speed
- **DownArrow** - Increase Step Speed

## Commands
- .sua - List StepUp Advanced commands.
- .sua add - Adds the targeted block to the step-up blacklist.
- .sua remove - Removes the targeted block from the step-up blacklist.

>StepUp Advanced provides a balance between automation and control, giving players the tools to adapt their gameplay effortlessly. Whether you're crafting, exploring, or in the heat of survival, this mod ensures you never lose momentum.

## Server Enforcement
**ServerEnforceSettings** allows server operators to restrict step values globally. When enabled:
- Clients receive the server-defined configuration upon joining.
- Hotkeys for height/speed changes are disabled if not permitted.
- All changes are clamped between the server's min/max limits.
- Server-configured limits are also validated and corrected if out-of-bounds.

## Support

If you enjoy this mod and want to support future development:<strong><a href="https://ko-fi.com/elo"><img class="giphy-gif-img giphy-img-loaded" src="https://media2.giphy.com/media/bZgsAwXUIVU2tcKn7s/100.gif" alt="Heart Support Sticker by Ko-fi" width="188" height="43" /></a></strong>


#### Please Discuss Features: [VS Discord StepUp Advanced Thread](https://discord.com/channels/302152934249070593/1331031307379146814)

#### Latest version is compatible with older and current versions of Vintage Story! (not tested below version 1.19.8)


#### Credits: [CopyGirl][CG] => [StepUp][SU]
[CG]: https://mods.vintagestory.at/list/mod?sortby=lastreleased&sortdir=desc&text=&side=&userid=41&mv=

### Note:

>This mod includes a hardcoded maximum step height of 2 blocks, which may be controversial for some users. The reason for it being 2 blocks currently, is to give a decent customizable range. Although, intentionally, this mod is required on a server for it to work on a server so that it doesn't act as a 'cheat'.

>Additionally, if you have any feature requests or ideas for enhancements, feel free to share them with me! Your input will help shape the future of StepUp Advanced and ensure it fits the needs of the community.

<a href="https://discord.com/users/111920932842450944" target="_blank" rel="noopener"><img src="https://discord.c99.nl/widget/theme-1/111920932842450944.png" alt="" width="395" height="80" /></a>